<?php

namespace App\Console\Commands;

use App\Models\Product;
use Illuminate\Console\Command;

class UpdateProductsStockFromSizes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'products:update-stock-from-sizes';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'تحديث المخزون الأساسي للمنتجات من مجموع القياسات';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('بدء تحديث المخزون للمنتجات...');
        
        $products = Product::with('sizes')->get();
        $updated = 0;
        
        foreach ($products as $product) {
            if ($product->sizes->count() > 0) {
                $totalStock = $product->sizes->sum(function($size) {
                    return $size->pivot->stock ?? 0;
                });
                
                if ($product->stock != $totalStock) {
                    $product->stock = $totalStock;
                    $product->save();
                    $updated++;
                    $this->line("تم تحديث المنتج: {$product->name} - المخزون: {$product->stock} → {$totalStock}");
                }
            }
        }
        
        $this->info("تم تحديث {$updated} منتج بنجاح!");
        
        return Command::SUCCESS;
    }
}
