<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\Category;
use App\Models\Order;
use App\Models\User;
use App\Models\Slider;
use App\Models\Size;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    /**
     * Display admin dashboard with store management
     */
    public function index()
    {
        // إحصائيات عامة
        $stats = [
            'total_products' => Product::count(),
            'active_products' => Product::where('is_active', true)->count(),
            'inactive_products' => Product::where('is_active', false)->count(),
            'total_categories' => Category::count(),
            'active_categories' => Category::where('is_active', true)->count(),
            'inactive_categories' => Category::where('is_active', false)->count(),
            'total_orders' => Order::count(),
            'pending_orders' => Order::where('status', 'pending')->count(),
            'processing_orders' => Order::where('status', 'processing')->count(),
            'shipped_orders' => Order::where('status', 'shipped')->count(),
            'delivered_orders' => Order::where('status', 'delivered')->count(),
            'cancelled_orders' => Order::where('status', 'cancelled')->count(),
            'total_customers' => User::where('role', '!=', 'admin')->count(),
            'total_sliders' => Slider::count(),
            'active_sliders' => Slider::where('is_active', true)->count(),
            'total_sizes' => Size::count(),
            'active_sizes' => Size::where('is_active', true)->count(),
            'total_revenue' => Order::where('status', '!=', 'cancelled')->sum('total_amount'),
            'today_orders' => Order::whereDate('created_at', today())->count(),
            'today_revenue' => Order::whereDate('created_at', today())
                ->where('status', '!=', 'cancelled')
                ->sum('total_amount'),
        ];

        // آخر الطلبات
        $recent_orders = Order::with('user')
            ->latest()
            ->limit(5)
            ->get();

        // منتجات قليلة المخزون
        $low_stock_products = Product::where('stock', '<', 10)
            ->where('is_active', true)
            ->orderBy('stock', 'asc')
            ->limit(5)
            ->get();

        // آخر التصنيفات
        $recent_categories = Category::latest()->limit(5)->get();

        // آخر المنتجات
        $recent_products = Product::with('category')->latest()->limit(5)->get();

        return view('admin.settings.index', compact('stats', 'recent_orders', 'low_stock_products', 'recent_categories', 'recent_products'));
    }
}

