<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $categories = Category::where('is_active', true)->take(8)->get();
        $featuredProducts = Product::where('is_active', true)
            ->where('stock', '>', 0)
            ->with('category')
            ->latest()
            ->take(8)
            ->get();
        $newProducts = Product::where('is_active', true)
            ->where('stock', '>', 0)
            ->with('category')
            ->latest()
            ->take(8)
            ->get();
        
        return view('home', compact('categories', 'featuredProducts', 'newProducts'));
    }
}
