<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class NotAdminMiddleware
{
    /**
     * Handle an incoming request.
     * Prevents admin users from accessing customer features like orders and cart.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->check() && auth()->user()->isAdmin()) {
            return redirect()->route('admin.sliders.index')
                ->with('error', app()->getLocale() === 'ar' 
                    ? 'حساب المدير مخصص لإدارة المتجر فقط. لا يمكنك إضافة طلبات.' 
                    : 'Admin account is for store management only. You cannot place orders.');
        }

        return $next($request);
    }
}





