<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // إعادة تسمية الأعمدة العربية
            if (Schema::hasColumn('products', 'name_ar')) {
                DB::statement('ALTER TABLE `products` CHANGE `name_ar` `name` VARCHAR(255) NOT NULL');
            }
            if (Schema::hasColumn('products', 'description_ar')) {
                DB::statement('ALTER TABLE `products` CHANGE `description_ar` `description` TEXT NULL');
            }
            
            // حذف الأعمدة الإنجليزية
            if (Schema::hasColumn('products', 'name_en')) {
                $table->dropColumn('name_en');
            }
            if (Schema::hasColumn('products', 'description_en')) {
                $table->dropColumn('description_en');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // إعادة الأعمدة الإنجليزية
            $table->string('name_en')->after('name');
            $table->text('description_en')->nullable()->after('description');
            
            // إعادة تسمية الأعمدة
            if (Schema::hasColumn('products', 'name')) {
                DB::statement('ALTER TABLE `products` CHANGE `name` `name_ar` VARCHAR(255) NOT NULL');
            }
            if (Schema::hasColumn('products', 'description')) {
                DB::statement('ALTER TABLE `products` CHANGE `description` `description_ar` TEXT NULL');
            }
        });
    }
};
