<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // تأكيد وجود عمود name
            if (!Schema::hasColumn('products', 'name') && Schema::hasColumn('products', 'name_ar')) {
                DB::statement('ALTER TABLE `products` CHANGE `name_ar` `name` VARCHAR(255) NOT NULL');
            } elseif (!Schema::hasColumn('products', 'name')) {
                $table->string('name')->default('')->after('category_id');
            }

            // تأكيد وجود عمود description
            if (!Schema::hasColumn('products', 'description') && Schema::hasColumn('products', 'description_ar')) {
                DB::statement('ALTER TABLE `products` CHANGE `description_ar` `description` TEXT NULL');
            } elseif (!Schema::hasColumn('products', 'description')) {
                $table->text('description')->nullable()->after('name');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // لا حاجة لعكس العملية هنا حتى لا نكسر البيانات الموجودة
    }
};


