<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $adminUsers = [
            [
                'name' => 'Admin User',
                'email' => 'admin@onlinestore.com',
                'password' => Hash::make('admin123'),
                'role' => 'admin',
                'points' => 1000,
            ],
            [
                'name' => 'Super Admin',
                'email' => 'superadmin@onlinestore.com',
                'password' => Hash::make('superadmin123'),
                'role' => 'admin',
                'points' => 5000,
            ],
            [
                'name' => 'Demo Admin',
                'email' => 'demo@onlinestore.com',
                'password' => Hash::make('demo123'),
                'role' => 'admin',
                'points' => 2000,
            ],
        ];

        foreach ($adminUsers as $adminUser) {
            User::updateOrCreate(
                ['email' => $adminUser['email']],
                $adminUser
            );
        }

        $this->command->info('Admin users created successfully!');
        $this->command->info('Login credentials:');
        $this->command->info('  - admin@onlinestore.com / admin123');
        $this->command->info('  - superadmin@onlinestore.com / superadmin123');
        $this->command->info('  - demo@onlinestore.com / demo123');
    }
}
