<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Database\Seeder;

class DemoDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Categories
        $categories = [
            [
                'name_ar' => 'إلكترونيات',
                'name_en' => 'Electronics',
                'description_ar' => 'أحدث الأجهزة الإلكترونية والتقنية',
                'description_en' => 'Latest electronic devices and technology',
                'image' => 'https://images.unsplash.com/photo-1498049794561-7780e7231661?w=400&h=300&fit=crop',
            ],
            [
                'name_ar' => 'ملابس',
                'name_en' => 'Clothing',
                'description_ar' => 'أزياء وملابس عصرية',
                'description_en' => 'Fashionable and trendy clothing',
                'image' => 'https://images.unsplash.com/photo-1441986300917-64674bd600d8?w=400&h=300&fit=crop',
            ],
            [
                'name_ar' => 'أثاث',
                'name_en' => 'Furniture',
                'description_ar' => 'أثاث منزلي ومكتبي',
                'description_en' => 'Home and office furniture',
                'image' => 'https://images.unsplash.com/photo-1586023492125-27b2c045efd7?w=400&h=300&fit=crop',
            ],
            [
                'name_ar' => 'كتب',
                'name_en' => 'Books',
                'description_ar' => 'كتب ومجلات متنوعة',
                'description_en' => 'Various books and magazines',
                'image' => 'https://images.unsplash.com/photo-1544947950-fa07a98d237f?w=400&h=300&fit=crop',
            ],
            [
                'name_ar' => 'ألعاب',
                'name_en' => 'Toys',
                'description_ar' => 'ألعاب للأطفال والكبار',
                'description_en' => 'Toys for children and adults',
                'image' => 'https://images.unsplash.com/photo-1553062407-98eeb64c6a62?w=400&h=300&fit=crop',
            ],
            [
                'name_ar' => 'رياضة',
                'name_en' => 'Sports',
                'description_ar' => 'معدات وأدوات رياضية',
                'description_en' => 'Sports equipment and gear',
                'image' => 'https://images.unsplash.com/photo-1571019613454-1cb2f99b2d8b?w=400&h=300&fit=crop',
            ],
            [
                'name_ar' => 'جمال',
                'name_en' => 'Beauty',
                'description_ar' => 'منتجات العناية والجمال',
                'description_en' => 'Beauty and care products',
                'image' => 'https://images.unsplash.com/photo-1596462502278-27bfdc403348?w=400&h=300&fit=crop',
            ],
            [
                'name_ar' => 'طعام',
                'name_en' => 'Food',
                'description_ar' => 'أطعمة ومشروبات',
                'description_en' => 'Food and beverages',
                'image' => 'https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=400&h=300&fit=crop',
            ],
        ];

        $createdCategories = [];
        foreach ($categories as $categoryData) {
            $category = Category::create($categoryData);
            $createdCategories[] = $category;
        }

        // Create Products
        $products = [
            // Electronics
            [
                'category_id' => $createdCategories[0]->id,
                'name_ar' => 'هاتف ذكي سامسونج',
                'name_en' => 'Samsung Smartphone',
                'description_ar' => 'هاتف ذكي بمواصفات عالية وكاميرا ممتازة',
                'description_en' => 'High-end smartphone with excellent camera',
                'price' => 2499.00,
                'stock' => 15,
                'image' => 'https://images.unsplash.com/photo-1511707171634-5f897ff02aa9?w=400&h=400&fit=crop',
                'points_earned' => 250,
            ],
            [
                'category_id' => $createdCategories[0]->id,
                'name_ar' => 'سماعات لاسلكية',
                'name_en' => 'Wireless Headphones',
                'description_ar' => 'سماعات لاسلكية بجودة صوت عالية',
                'description_en' => 'Wireless headphones with high sound quality',
                'price' => 399.00,
                'stock' => 30,
                'image' => 'https://images.unsplash.com/photo-1505740420928-5e560c06d30e?w=400&h=400&fit=crop',
                'points_earned' => 40,
            ],
            [
                'category_id' => $createdCategories[0]->id,
                'name_ar' => 'ساعة ذكية',
                'name_en' => 'Smart Watch',
                'description_ar' => 'ساعة ذكية متعددة الوظائف',
                'description_en' => 'Multi-functional smartwatch',
                'price' => 899.00,
                'stock' => 20,
                'image' => 'https://images.unsplash.com/photo-1523275335684-37898b6baf30?w=400&h=400&fit=crop',
                'points_earned' => 90,
            ],
            [
                'category_id' => $createdCategories[0]->id,
                'name_ar' => 'تابلت',
                'name_en' => 'Tablet',
                'description_ar' => 'جهاز لوحي بشاشة عالية الدقة',
                'description_en' => 'Tablet with high-resolution screen',
                'price' => 1299.00,
                'stock' => 12,
                'image' => 'https://images.unsplash.com/photo-1544244015-0df4b3ffc6b0?w=400&h=400&fit=crop',
                'points_earned' => 130,
            ],
            // Clothing
            [
                'category_id' => $createdCategories[1]->id,
                'name_ar' => 'قميص رجالي',
                'name_en' => 'Men\'s Shirt',
                'description_ar' => 'قميص رجالي أنيق وعصري',
                'description_en' => 'Elegant and modern men\'s shirt',
                'price' => 149.00,
                'stock' => 50,
                'image' => 'https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=400&h=400&fit=crop',
                'points_earned' => 15,
            ],
            [
                'category_id' => $createdCategories[1]->id,
                'name_ar' => 'فستان نسائي',
                'name_en' => 'Women\'s Dress',
                'description_ar' => 'فستان نسائي أنيق ومناسب للمناسبات',
                'description_en' => 'Elegant women\'s dress perfect for occasions',
                'price' => 299.00,
                'stock' => 35,
                'image' => 'https://images.unsplash.com/photo-1595777457583-95e059d581b8?w=400&h=400&fit=crop',
                'points_earned' => 30,
            ],
            [
                'category_id' => $createdCategories[1]->id,
                'name_ar' => 'جاكيت شتوي',
                'name_en' => 'Winter Jacket',
                'description_ar' => 'جاكيت شتوي دافئ ومريح',
                'description_en' => 'Warm and comfortable winter jacket',
                'price' => 449.00,
                'stock' => 25,
                'image' => 'https://images.unsplash.com/photo-1551028719-00167b16eac5?w=400&h=400&fit=crop',
                'points_earned' => 45,
            ],
            // Furniture
            [
                'category_id' => $createdCategories[2]->id,
                'name_ar' => 'طاولة مكتب',
                'name_en' => 'Office Desk',
                'description_ar' => 'طاولة مكتب عصرية ومريحة',
                'description_en' => 'Modern and comfortable office desk',
                'price' => 799.00,
                'stock' => 10,
                'image' => 'https://images.unsplash.com/photo-1586023492125-27b2c045efd7?w=400&h=400&fit=crop',
                'points_earned' => 80,
            ],
            [
                'category_id' => $createdCategories[2]->id,
                'name_ar' => 'كرسي مكتب',
                'name_en' => 'Office Chair',
                'description_ar' => 'كرسي مكتب مريح ومزود بدعم للظهر',
                'description_en' => 'Comfortable office chair with back support',
                'price' => 599.00,
                'stock' => 15,
                'image' => 'https://images.unsplash.com/photo-1506439773649-6e0eb8cfb237?w=400&h=400&fit=crop',
                'points_earned' => 60,
            ],
            [
                'category_id' => $createdCategories[2]->id,
                'name_ar' => 'أريكة',
                'name_en' => 'Sofa',
                'description_ar' => 'أريكة مريحة وأنيقة للمنزل',
                'description_en' => 'Comfortable and elegant sofa for home',
                'price' => 2499.00,
                'stock' => 5,
                'image' => 'https://images.unsplash.com/photo-1555041469-a586c61ea9bc?w=400&h=400&fit=crop',
                'points_earned' => 250,
            ],
            // Books
            [
                'category_id' => $createdCategories[3]->id,
                'name_ar' => 'رواية عربية',
                'name_en' => 'Arabic Novel',
                'description_ar' => 'رواية أدبية رائعة',
                'description_en' => 'Wonderful literary novel',
                'price' => 49.00,
                'stock' => 100,
                'image' => 'https://images.unsplash.com/photo-1544947950-fa07a98d237f?w=400&h=400&fit=crop',
                'points_earned' => 5,
            ],
            [
                'category_id' => $createdCategories[3]->id,
                'name_ar' => 'كتاب تعليمي',
                'name_en' => 'Educational Book',
                'description_ar' => 'كتاب تعليمي مفيد',
                'description_en' => 'Useful educational book',
                'price' => 79.00,
                'stock' => 80,
                'image' => 'https://images.unsplash.com/photo-1532012197267-da84d127e765?w=400&h=400&fit=crop',
                'points_earned' => 8,
            ],
            // Toys
            [
                'category_id' => $createdCategories[4]->id,
                'name_ar' => 'لعبة أطفال',
                'name_en' => 'Kids Toy',
                'description_ar' => 'لعبة تعليمية للأطفال',
                'description_en' => 'Educational toy for children',
                'price' => 99.00,
                'stock' => 60,
                'image' => 'https://images.unsplash.com/photo-1553062407-98eeb64c6a62?w=400&h=400&fit=crop',
                'points_earned' => 10,
            ],
            [
                'category_id' => $createdCategories[4]->id,
                'name_ar' => 'لعبة أركيت',
                'name_en' => 'Action Figure',
                'description_ar' => 'شخصية كرتونية محبوبة',
                'description_en' => 'Beloved cartoon character',
                'price' => 149.00,
                'stock' => 40,
                'image' => 'https://images.unsplash.com/photo-1550745165-9bc0b252726f?w=400&h=400&fit=crop',
                'points_earned' => 15,
            ],
            // Sports
            [
                'category_id' => $createdCategories[5]->id,
                'name_ar' => 'كرة قدم',
                'name_en' => 'Football',
                'description_ar' => 'كرة قدم احترافية',
                'description_en' => 'Professional football',
                'price' => 199.00,
                'stock' => 45,
                'image' => 'https://images.unsplash.com/photo-1431324155629-1a6deb1dec8d?w=400&h=400&fit=crop',
                'points_earned' => 20,
            ],
            [
                'category_id' => $createdCategories[5]->id,
                'name_ar' => 'دراجة هوائية',
                'name_en' => 'Bicycle',
                'description_ar' => 'دراجة هوائية رياضية',
                'description_en' => 'Sports bicycle',
                'price' => 1299.00,
                'stock' => 8,
                'image' => 'https://images.unsplash.com/photo-1571068316344-75bc76f77890?w=400&h=400&fit=crop',
                'points_earned' => 130,
            ],
            // Beauty
            [
                'category_id' => $createdCategories[6]->id,
                'name_ar' => 'عطر نسائي',
                'name_en' => 'Women\'s Perfume',
                'description_ar' => 'عطر نسائي برائحة عطرية مميزة',
                'description_en' => 'Women\'s perfume with distinctive fragrance',
                'price' => 349.00,
                'stock' => 30,
                'image' => 'https://images.unsplash.com/photo-1541643600914-78b084683601?w=400&h=400&fit=crop',
                'points_earned' => 35,
            ],
            [
                'category_id' => $createdCategories[6]->id,
                'name_ar' => 'مستحضرات تجميل',
                'name_en' => 'Makeup Kit',
                'description_ar' => 'طقم مستحضرات تجميل كامل',
                'description_en' => 'Complete makeup kit',
                'price' => 199.00,
                'stock' => 25,
                'image' => 'https://images.unsplash.com/photo-1596462502278-27bfdc403348?w=400&h=400&fit=crop',
                'points_earned' => 20,
            ],
            // Food
            [
                'category_id' => $createdCategories[7]->id,
                'name_ar' => 'قهوة عربية',
                'name_en' => 'Arabic Coffee',
                'description_ar' => 'قهوة عربية أصيلة',
                'description_en' => 'Authentic Arabic coffee',
                'price' => 89.00,
                'stock' => 70,
                'image' => 'https://images.unsplash.com/photo-1514432324607-a09d9b4aefdd?w=400&h=400&fit=crop',
                'points_earned' => 9,
            ],
            [
                'category_id' => $createdCategories[7]->id,
                'name_ar' => 'شوكولاتة فاخرة',
                'name_en' => 'Luxury Chocolate',
                'description_ar' => 'شوكولاتة فاخرة عالية الجودة',
                'description_en' => 'High-quality luxury chocolate',
                'price' => 129.00,
                'stock' => 50,
                'image' => 'https://images.unsplash.com/photo-1606312619070-d48b4bc98c90?w=400&h=400&fit=crop',
                'points_earned' => 13,
            ],
        ];

        foreach ($products as $productData) {
            Product::create($productData);
        }

        $this->command->info('Demo data seeded successfully!');
        $this->command->info('Created ' . count($createdCategories) . ' categories');
        $this->command->info('Created ' . count($products) . ' products');
    }
}
