@extends('layouts.app')

@section('title', 'إضافة منتج جديد')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-6">
        <a href="{{ route('admin.products.index') }}" class="text-primary hover:opacity-80">← رجوع</a>
    </div>

    <h1 class="text-3xl font-bold text-gray-900 mb-6">إضافة منتج جديد</h1>

    @if($errors->any())
        <div class="bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded mb-4">
            <ul class="list-disc list-inside">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded mb-4">
            {{ session('error') }}
        </div>
    @endif

    <div class="bg-white rounded-lg shadow p-6">
        <form action="{{ route('admin.products.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">التصنيف <span class="text-primary">*</span></label>
                <select name="category_id" class="w-full px-4 py-2 border rounded-lg" required>
                    <option value="">اختر التصنيف</option>
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                            {{ $category->name }}
                        </option>
                    @endforeach
                </select>
                @error('category_id')
                <p class="text-primary text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">الاسم <span class="text-primary">*</span></label>
                <input type="text" name="name" value="{{ old('name') }}" class="w-full px-4 py-2 border rounded-lg" required>
                @error('name')
                <p class="text-primary text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">الوصف</label>
                <textarea name="description" rows="3" class="w-full px-4 py-2 border rounded-lg">{{ old('description') }}</textarea>
                @error('description')
                <p class="text-primary text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <div>
                    <label class="block text-gray-700 mb-2">السعر <span class="text-primary">*</span></label>
                    <input type="number" name="price" step="0.01" min="0" value="{{ old('price') }}" class="w-full px-4 py-2 border rounded-lg" required>
                    @error('price')
                    <p class="text-primary text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-gray-700 mb-2">المخزون <span class="text-primary">*</span></label>
                    <input type="number" name="stock" min="0" value="{{ old('stock', 0) }}" class="w-full px-4 py-2 border rounded-lg" required id="product-stock">
                    <p class="text-xs text-gray-500 mt-1" id="stock-note">سيتم حساب المخزون تلقائياً من مجموع القياسات إذا اخترت قياسات للمنتج</p>
                    @error('stock')
                    <p class="text-primary text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">الصورة <span class="text-primary">*</span></label>
                <input type="file" name="image" accept="image/jpeg,image/png,image/jpg,image/webp" required class="w-full px-4 py-2 border rounded-lg">
                <p class="text-xs text-gray-500 mt-1">الأنواع المدعومة: JPEG, PNG, JPG, WEBP - الحد الأقصى: 5 ميجابايت</p>
                @error('image')
                <p class="text-red-600 text-sm mt-1 font-semibold">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">النقاط المكتسبة</label>
                <input type="number" name="points_earned" min="0" value="{{ old('points_earned', 0) }}" class="w-full px-4 py-2 border rounded-lg">
                @error('points_earned')
                <p class="text-primary text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="flex items-center cursor-pointer">
                    <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }} class="mr-2">
                    <span class="text-gray-700">نشط</span>
                </label>
            </div>

            <div class="mb-6">
                <label class="flex items-center cursor-pointer">
                    <input type="checkbox" name="is_custom" value="1" {{ old('is_custom') ? 'checked' : '' }} class="mr-2">
                    <span class="text-gray-700">منتج تفصيل (يحتاج قياسات مخصصة)</span>
                </label>
                <p class="text-sm text-gray-500 mt-1">إذا كان المنتج تفصيل، سيحتاج العميل إلى إدخال القياسات المطلوبة</p>
            </div>

            <div class="mb-6 border-t pt-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">القياسات المتاحة</h3>
                <p class="text-sm text-gray-600 mb-4">اختر القياسات المرتبطة بهذا المنتج (اختياري)</p>
                
                @if($sizes->count() > 0)
                    <div class="space-y-4" id="sizes-container">
                        @foreach($sizes as $size)
                            <div class="border rounded-lg p-4 size-item" data-size-id="{{ $size->id }}">
                                <div class="flex items-center justify-between mb-3">
                                    <label class="flex items-center cursor-pointer">
                                        <input type="checkbox" name="sizes[]" value="{{ $size->id }}" class="size-checkbox mr-2" onchange="toggleSizeFields({{ $size->id }})">
                                        <span class="text-gray-700 font-medium">{{ $size->name }}</span>
                                    </label>
                                </div>
                                <div class="size-fields hidden grid grid-cols-1 md:grid-cols-2 gap-4" id="size-fields-{{ $size->id }}">
                                    <div>
                                        <label class="block text-gray-700 mb-2 text-sm">المخزون للقياس</label>
                                        <input type="number" name="size_stocks[{{ $size->id }}]" min="0" value="0" class="w-full px-3 py-2 border rounded-lg text-sm">
                                    </div>
                                    <div>
                                        <label class="block text-gray-700 mb-2 text-sm">سعر خاص (اختياري)</label>
                                        <input type="number" name="size_prices[{{ $size->id }}]" step="0.01" min="0" placeholder="اتركه فارغاً لاستخدام السعر الأساسي" class="w-full px-3 py-2 border rounded-lg text-sm">
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                        <p class="text-yellow-800 text-sm">لا توجد قياسات متاحة. <a href="{{ route('admin.sizes.create') }}" class="underline">أضف قياسات جديدة</a></p>
                    </div>
                @endif
            </div>

            <div class="flex gap-4">
                <button type="submit" class="bg-primary text-white px-6 py-2 rounded-lg hover:opacity-90 transition">
                    حفظ
                </button>
                <a href="{{ route('admin.products.index') }}" class="bg-gray-200 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-300 transition">
                    إلغاء
                </a>
            </div>
        </form>
    </div>
</div>

<script>
function toggleSizeFields(sizeId) {
    const checkbox = document.querySelector(`input[value="${sizeId}"].size-checkbox`);
    const fields = document.getElementById(`size-fields-${sizeId}`);
    
    if (checkbox.checked) {
        fields.classList.remove('hidden');
    } else {
        fields.classList.add('hidden');
        // إعادة تعيين المخزون للقياس إلى 0 عند إلغاء التحديد
        const stockInput = fields.querySelector('input[name^="size_stocks"]');
        if (stockInput) {
            stockInput.value = 0;
        }
    }
    
    // حساب مجموع القياسات
    calculateTotalStock();
}

function calculateTotalStock() {
    const stockInput = document.getElementById('product-stock');
    const stockNote = document.getElementById('stock-note');
    let totalStock = 0;
    
    // جمع جميع مخزونات القياسات المحددة
    document.querySelectorAll('.size-checkbox:checked').forEach(checkbox => {
        const sizeId = checkbox.value;
        const sizeFields = document.getElementById(`size-fields-${sizeId}`);
        if (sizeFields) {
            const sizeStockInput = sizeFields.querySelector(`input[name="size_stocks[${sizeId}]"]`);
            if (sizeStockInput) {
                totalStock += parseInt(sizeStockInput.value) || 0;
            }
        }
    });
    
    // إذا كان هناك قياسات محددة، تحديث المخزون الأساسي
    const hasSizes = document.querySelectorAll('.size-checkbox:checked').length > 0;
    if (hasSizes && totalStock > 0) {
        stockInput.value = totalStock;
        stockNote.textContent = `المخزون الأساسي = مجموع القياسات (${totalStock})`;
        stockNote.classList.remove('text-gray-500');
        stockNote.classList.add('text-primary', 'font-semibold');
    } else {
        stockNote.textContent = 'سيتم حساب المخزون تلقائياً من مجموع القياسات إذا اخترت قياسات للمنتج';
        stockNote.classList.remove('text-primary', 'font-semibold');
        stockNote.classList.add('text-gray-500');
    }
}

// إضافة مستمعات الأحداث لحقول مخزون القياسات
document.addEventListener('DOMContentLoaded', function() {
    // إضافة مستمعات لجميع حقول مخزون القياسات
    document.querySelectorAll('input[name^="size_stocks"]').forEach(input => {
        input.addEventListener('input', calculateTotalStock);
    });
    
    // حساب المجموع الأولي
    calculateTotalStock();
});
</script>
@endsection

