@extends('layouts.app')

@section('title', 'إدارة السلايدر')

@php
use Illuminate\Support\Facades\Storage;
@endphp

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">إدارة السلايدر</h1>
        @php
            $activeCount = $sliders->where('is_active', true)->count();
        @endphp
        @if($activeCount < 3)
            <a href="{{ route('admin.sliders.create') }}" class="bg-primary text-white px-6 py-2 rounded-lg hover:opacity-90 transition">
                + إضافة سلايدر جديد
            </a>
        @else
            <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-6 py-2 rounded-lg text-sm">
                تم الوصول للحد الأقصى (3 صور نشطة)
            </div>
        @endif
    </div>

    @if(session('success'))
        <div class="bg-success/20 border border-success text-success px-4 py-3 rounded mb-4">
            {{ session('success') }}
        </div>
    @endif

    @if($activeCount > 0)
        <div class="bg-blue-50 border-r-4 border-blue-400 p-4 mb-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="mr-3">
                    <p class="text-sm text-blue-700">
                        <strong>معلومة:</strong> يتم عرض {{ $activeCount }} من 3 صور نشطة على الصفحة الرئيسية. 
                        @if($activeCount < 3)
                            يمكنك إضافة {{ 3 - $activeCount }} صورة إضافية.
                        @endif
                    </p>
                </div>
            </div>
        </div>
    @endif

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">الصورة</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">العنوان</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">الترتيب</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">الحالة</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">الإجراءات</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($sliders as $slider)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap">
                        @if($slider->image)
                            <img src="{{ $slider->image_url }}" 
                                 alt="{{ $slider->title }}" 
                                 class="h-20 w-32 object-cover rounded"
                                 onerror="this.src='data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' width=\'128\' height=\'80\'%3E%3Crect fill=\'%23ddd\' width=\'128\' height=\'80\'/%3E%3Ctext fill=\'%23999\' font-family=\'sans-serif\' font-size=\'14\' x=\'50%25\' y=\'50%25\' text-anchor=\'middle\' dy=\'.3em\'%3Eلا توجد صورة%3C/text%3E%3C/svg%3E';">
                        @else
                            <div class="h-20 w-32 bg-gray-200 rounded flex items-center justify-center text-xs text-gray-500">
                                لا توجد صورة
                            </div>
                        @endif
                    </td>
                    <td class="px-6 py-4">
                        <div class="text-sm font-medium text-gray-900">{{ $slider->title }}</div>
                        @if($slider->link)
                        <div class="text-sm text-gray-500">{{ $slider->link }}</div>
                        @endif
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $slider->order }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $slider->is_active ? 'bg-success text-white' : 'bg-gray-200 text-gray-800' }}">
                            {{ $slider->is_active ? 'نشط' : 'غير نشط' }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="flex items-center gap-2">
                            <a href="{{ route('admin.sliders.edit', $slider->id) }}" class="group inline-flex items-center px-4 py-2 bg-gradient-to-r from-blue-500 to-blue-600 text-white rounded-lg hover:from-blue-600 hover:to-blue-700 transition-all duration-200 shadow-md hover:shadow-lg text-sm font-medium">
                                <svg class="w-4 h-4 ml-2 group-hover:rotate-12 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                </svg>
                                تعديل
                            </a>
                            <form action="{{ route('admin.sliders.destroy', $slider->id) }}" method="POST" class="inline delete-form" data-confirm-message="هل أنت متأكد من حذف السلايدر '{{ $slider->title }}'؟ لا يمكن التراجع عن هذا الإجراء.">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="group inline-flex items-center px-4 py-2 bg-gradient-to-r from-red-500 to-red-600 text-white rounded-lg hover:from-red-600 hover:to-red-700 transition-all duration-200 shadow-md hover:shadow-lg text-sm font-medium">
                                    <svg class="w-4 h-4 ml-2 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                    </svg>
                                    حذف
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="px-6 py-4 text-center text-gray-500">
                        لا توجد سلايدرات
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
