@extends('layouts.app')

@section('title', __('messages.login'))

@section('content')
<div class="max-w-md mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="bg-white rounded-lg shadow p-6">
        <h2 class="text-2xl font-bold mb-6 text-center">{{ __('messages.login') }}</h2>
        
        <form method="POST" action="{{ route('login') }}">
            @csrf
            @if(isset($redirect))
            <input type="hidden" name="redirect" value="{{ $redirect }}">
            @endif
            
            <div class="mb-4">
                <label class="block text-gray-700 mb-2">{{ __('messages.email') }}</label>
                <input type="email" name="email" value="{{ old('email') }}" required
                       class="w-full px-4 py-2 border rounded-lg">
                @error('email')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
            
            <div class="mb-4">
                <label class="block text-gray-700 mb-2">{{ __('messages.password') }}</label>
                <input type="password" name="password" required
                       class="w-full px-4 py-2 border rounded-lg">
                @error('password')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
            
            <div class="mb-4">
                <label class="flex items-center">
                    <input type="checkbox" name="remember" class="mr-2 rtl:ml-2 rtl:mr-0">
                    <span class="text-sm text-gray-600">{{ __('messages.remember_me') }}</span>
                </label>
            </div>
            
            <button type="submit" class="w-full bg-primary text-white px-6 py-3 rounded-lg hover:opacity-90 transition">
                {{ __('messages.login') }}
            </button>
        </form>
        
        <p class="mt-4 text-center text-sm text-gray-600">
            {{ __('messages.dont_have_account') ?? "Don't have an account?" }} <a href="{{ route('register', array_filter(['lang' => app()->getLocale(), 'redirect' => $redirect ?? null])) }}" class="text-primary hover:opacity-80">{{ __('messages.register') }}</a>
        </p>
    </div>
</div>
@endsection

