<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{ app()->getLocale() === 'ar' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ app()->getLocale() === 'ar' ? 'تحديث حالة الطلب' : 'Order Status Update' }}</title>
    <style>
        body {
            font-family: {{ app()->getLocale() === 'ar' ? 'Cairo, Arial' : 'Inter, Arial' }}, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            padding: 30px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #1e9a8e;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .header h1 {
            color: #1e9a8e;
            margin: 0;
            font-size: 24px;
        }
        .status-box {
            background-color: #f0f9f8;
            border-left: 4px solid #1e9a8e;
            padding: 20px;
            margin: 20px 0;
            border-radius: 5px;
        }
        .status-box h2 {
            color: #1e9a8e;
            margin-top: 0;
        }
        .status-badge {
            display: inline-block;
            padding: 8px 16px;
            background-color: #1e9a8e;
            color: white;
            border-radius: 5px;
            font-weight: bold;
            margin-top: 10px;
        }
        .order-info {
            background-color: #f9f9f9;
            padding: 20px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }
        .info-row:last-child {
            border-bottom: none;
        }
        .info-label {
            font-weight: bold;
            color: #666;
        }
        .info-value {
            color: #333;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #666;
            font-size: 14px;
        }
        .button {
            display: inline-block;
            padding: 12px 30px;
            background-color: #1e9a8e;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 20px;
        }
        .button:hover {
            background-color: #76c791;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>{{ app()->getLocale() === 'ar' ? 'تحديث حالة الطلب' : 'Order Status Update' }}</h1>
        </div>

        <div class="status-box">
            <h2>{{ app()->getLocale() === 'ar' ? 'تم تحديث حالة طلبك' : 'Your Order Status Has Been Updated' }}</h2>
            <p>
                {{ app()->getLocale() === 'ar' ? 'تم تغيير حالة الطلب من' : 'Order status changed from' }}
                <strong>{{ __('messages.' . $oldStatus) ?? ucfirst($oldStatus) }}</strong>
                {{ app()->getLocale() === 'ar' ? 'إلى' : 'to' }}
                <strong>{{ __('messages.' . $newStatus) ?? ucfirst($newStatus) }}</strong>
            </p>
            <div class="status-badge">
                {{ __('messages.' . $newStatus) ?? ucfirst($newStatus) }}
            </div>
        </div>

        <div class="order-info">
            <h2>{{ app()->getLocale() === 'ar' ? 'معلومات الطلب' : 'Order Information' }}</h2>
            <div class="info-row">
                <span class="info-label">{{ app()->getLocale() === 'ar' ? 'رقم الطلب:' : 'Order Number:' }}</span>
                <span class="info-value"><strong>#{{ $order->order_number }}</strong></span>
            </div>
            <div class="info-row">
                <span class="info-label">{{ app()->getLocale() === 'ar' ? 'تاريخ الطلب:' : 'Order Date:' }}</span>
                <span class="info-value">{{ $order->created_at->format('Y-m-d H:i') }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">{{ app()->getLocale() === 'ar' ? 'المبلغ الإجمالي:' : 'Total Amount:' }}</span>
                <span class="info-value">{{ number_format($order->total_amount, 2) }} {{ app()->getLocale() === 'ar' ? 'ر.ع' : 'OMR' }}</span>
            </div>
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <a href="{{ route('orders.show', $order->id) }}" class="button">
                {{ app()->getLocale() === 'ar' ? 'عرض تفاصيل الطلب' : 'View Order Details' }}
            </a>
        </div>

        <div class="footer">
            <p>{{ app()->getLocale() === 'ar' ? 'شكراً لك على اختيارنا!' : 'Thank you for choosing us!' }}</p>
            <p>&copy; {{ date('Y') }} {{ config('app.name') }}. {{ __('messages.all_rights_reserved') ?? 'All rights reserved' }}.</p>
        </div>
    </div>
</body>
</html>

