<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{ app()->getLocale() === 'ar' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ app()->getLocale() === 'ar' ? 'مرحباً بك' : 'Welcome' }}</title>
    <style>
        body {
            font-family: {{ app()->getLocale() === 'ar' ? 'Cairo, Arial' : 'Inter, Arial' }}, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            padding: 30px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #ff3131;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .header h1 {
            color: #ff3131;
            margin: 0;
            font-size: 28px;
        }
        .welcome-message {
            text-align: center;
            padding: 20px 0;
        }
        .welcome-message h2 {
            color: #1e9a8e;
            margin-bottom: 15px;
        }
        .features {
            background-color: #f9f9f9;
            padding: 20px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .features h3 {
            color: #1e9a8e;
            margin-top: 0;
        }
        .feature-item {
            padding: 10px 0;
            border-bottom: 1px solid #eee;
        }
        .feature-item:last-child {
            border-bottom: none;
        }
        .feature-icon {
            color: #76c791;
            margin-{{ app()->getLocale() === 'ar' ? 'left' : 'right' }}: 10px;
        }
        .button {
            display: inline-block;
            padding: 12px 30px;
            background-color: #ff3131;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 20px;
        }
        .button:hover {
            background-color: #ff8a81;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #666;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>{{ app()->getLocale() === 'ar' ? 'مرحباً بك في' : 'Welcome to' }} {{ config('app.name') }}!</h1>
        </div>

        <div class="welcome-message">
            <h2>{{ app()->getLocale() === 'ar' ? 'مرحباً' : 'Hello' }}, {{ $user->name }}!</h2>
            <p>
                {{ app()->getLocale() === 'ar' 
                    ? 'نحن سعداء بانضمامك إلينا! يمكنك الآن الاستمتاع بجميع ميزات المتجر.' 
                    : 'We are excited to have you join us! You can now enjoy all the store features.' }}
            </p>
        </div>

        <div class="features">
            <h3>{{ app()->getLocale() === 'ar' ? 'ما يمكنك فعله:' : 'What You Can Do:' }}</h3>
            <div class="feature-item">
                <span class="feature-icon">✓</span>
                {{ app()->getLocale() === 'ar' ? 'تصفح وشراء المنتجات' : 'Browse and purchase products' }}
            </div>
            <div class="feature-item">
                <span class="feature-icon">✓</span>
                {{ app()->getLocale() === 'ar' ? 'تتبع طلباتك' : 'Track your orders' }}
            </div>
            <div class="feature-item">
                <span class="feature-icon">✓</span>
                {{ app()->getLocale() === 'ar' ? 'اكسب نقاط مع كل شراء' : 'Earn points with every purchase' }}
            </div>
            <div class="feature-item">
                <span class="feature-icon">✓</span>
                {{ app()->getLocale() === 'ar' ? 'استمتع بعروض حصرية' : 'Enjoy exclusive offers' }}
            </div>
        </div>

        @if($user->points > 0)
        <div style="background-color: #e8f5e9; padding: 15px; border-radius: 5px; margin: 20px 0; text-align: center;">
            <strong style="color: #76c791;">
                {{ app()->getLocale() === 'ar' ? 'نقاطك الحالية:' : 'Your Current Points:' }} {{ $user->points }} {{ __('messages.points') }}
            </strong>
        </div>
        @endif

        <div style="text-align: center; margin-top: 30px;">
            <a href="{{ route('products.index') }}" class="button">
                {{ app()->getLocale() === 'ar' ? 'ابدأ التسوق الآن' : 'Start Shopping Now' }}
            </a>
        </div>

        <div class="footer">
            <p>{{ app()->getLocale() === 'ar' ? 'شكراً لك على انضمامك إلينا!' : 'Thank you for joining us!' }}</p>
            <p>&copy; {{ date('Y') }} {{ config('app.name') }}. {{ __('messages.all_rights_reserved') ?? 'All rights reserved' }}.</p>
        </div>
    </div>
</body>
</html>

