<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', __('messages.welcome')) - {{ config('app.name') }}</title>
    <!-- Favicon -->
    <link rel="icon" type="image/webp" href="{{ asset('images/main/icon.webp') }}">
    <link rel="shortcut icon" type="image/webp" href="{{ asset('images/main/icon.webp') }}">
    <link rel="apple-touch-icon" href="{{ asset('images/main/icon.webp') }}">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    @else
        <script src="https://cdn.tailwindcss.com"></script>
    @endif
    <style>
        body {
            font-family: 'Cairo', sans-serif;
        }
        [dir="rtl"] {
            direction: rtl;
        }
        [dir="ltr"] {
            direction: ltr;
        }
        /* Safe area for mobile devices */
        .safe-area-inset-bottom {
            padding-bottom: env(safe-area-inset-bottom);
        }
        /* Smooth transitions for mobile nav */
        @media (max-width: 768px) {
            body {
                padding-bottom: 64px;
            }
        }
        /* Fixed header for desktop only */
        @media (min-width: 769px) {
            nav {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                z-index: 50;
                width: 100%;
            }
            body {
                padding-top: 64px;
            }
        }
        /* Mobile menu animation */
        .mobile-menu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease-out;
        }
        .mobile-menu.open {
            max-height: 500px;
            transition: max-height 0.3s ease-in;
        }
        /* Text truncation */
        .line-clamp-2 {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
    </style>
</head>
<body class="bg-gray-50">
    <nav class="bg-white shadow-lg">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Desktop Header -->
            <div class="hidden sm:grid sm:grid-cols-3 items-center h-16">
                <!-- Logo -->
                <div class="flex justify-end rtl:justify-start">
                    <a href="{{ route('home') }}" class="flex items-center">
                        <img src="{{ asset('images/main/logo.webp') }}" alt="{{ config('app.name') }}" class="h-10 md:h-12 w-auto">
                    </a>
                </div>
                
                <!-- Menu -->
                <div class="flex justify-center items-center">
                    <div class="flex space-x-6 rtl:space-x-reverse">
                        <a href="{{ route('home') }}" class="text-gray-700 hover:text-primary transition text-sm font-medium {{ request()->routeIs('home') ? 'text-primary' : '' }}">
                            {{ __('messages.home') }}
                        </a>
                        <a href="{{ route('products.index') }}" class="text-gray-700 hover:text-primary transition text-sm font-medium {{ request()->routeIs('products.*') ? 'text-primary' : '' }}">
                            {{ __('messages.products') }}
                        </a>
                        @auth
                            @if(auth()->user()->isAdmin())
                                <a href="{{ route('admin.sliders.index') }}" class="text-gray-700 hover:text-primary transition text-sm font-medium {{ request()->routeIs('admin.*') ? 'text-primary' : '' }}">
                                    {{ __('messages.admin_dashboard') }}
                                </a>
                            @else
                                <a href="{{ route('orders.index') }}" class="text-gray-700 hover:text-primary transition text-sm font-medium {{ request()->routeIs('orders.index') || request()->routeIs('orders.show') ? 'text-primary' : '' }}">
                                    {{ __('messages.orders') }}
                                </a>
                            @endif
                        @endauth
                        <a href="{{ route('orders.track') }}" class="text-gray-700 hover:text-primary transition text-sm font-medium {{ request()->routeIs('orders.track') ? 'text-primary' : '' }}">
                            {{ __('messages.track_order') }}
                        </a>
                    </div>
                </div>
                
                <!-- Icons (Desktop/Tablet only) -->
                <div class="flex items-center justify-start rtl:justify-end space-x-3 rtl:space-x-reverse">
                    @php
                        if (Auth::check()) {
                            $cartCount = \App\Models\Cart::where('user_id', Auth::id())->sum('quantity');
                        } else {
                            $sessionCart = session('cart', []);
                            if (empty($sessionCart)) {
                                $cartCount = 0;
                            } else {
                                $first = reset($sessionCart);
                                if (is_array($first)) {
                                    $cartCount = collect($sessionCart)->sum(function ($item) {
                                        return $item['quantity'] ?? 0;
                                    });
                                } else {
                                    $cartCount = array_sum($sessionCart);
                                }
                            }
                        }
                    @endphp
                    
                    <!-- Cart Icon -->
                    <a href="{{ route('cart.index') }}" class="p-2 text-gray-600 hover:text-primary transition relative" title="{{ __('messages.cart') }}">
                        <span class="absolute top-0 right-0 rtl:left-0 rtl:right-auto bg-red-600 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center cart-count-badge" data-cart-count="{{ $cartCount }}" style="{{ $cartCount > 0 ? '' : 'display: none;' }}">
                            {{ $cartCount > 99 ? '99+' : $cartCount }}
                        </span>
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </a>
                    
                    <!-- User Icon -->
                    @auth
                        @if(auth()->user()->isAdmin())
                            <a href="{{ route('admin.sliders.index') }}" class="p-2 text-gray-600 hover:text-primary transition" title="{{ __('messages.admin_dashboard') }}">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                </svg>
                            </a>
                        @else
                            <a href="{{ route('orders.index') }}" class="p-2 text-gray-600 hover:text-primary transition" title="{{ __('messages.my_account') }}">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                </svg>
                            </a>
                        @endif
                    @else
                        <a href="{{ route('login') }}" class="p-2 text-gray-600 hover:text-primary transition" title="{{ __('messages.login') }}">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                        </a>
                    @endauth
                </div>
            </div>
                
            <!-- Mobile Header -->
            <div class="flex sm:hidden items-center justify-between h-16">
                    <a href="{{ route('home') }}" class="flex items-center">
                        <img src="{{ asset('images/main/logo.webp') }}" alt="{{ config('app.name') }}" class="h-10 w-auto">
                    </a>
                    <button type="button" id="mobile-menu-button" class="inline-flex items-center justify-center p-2 rounded-md text-gray-500 hover:text-gray-700 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-primary" aria-expanded="false">
                        <span class="sr-only">Open main menu</span>
                        <!-- Hamburger Icon -->
                        <svg id="mobile-menu-icon" class="block h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                        <!-- Close Icon -->
                        <svg id="mobile-menu-close" class="hidden h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
            </div>
        </div>
        <!-- Mobile Menu -->
        <div id="mobile-menu" class="mobile-menu sm:hidden">
            <div class="px-2 pt-2 pb-3 space-y-1 bg-white border-t">
                <a href="{{ route('home') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-gray-900 hover:bg-gray-50 {{ request()->routeIs('home') ? 'bg-primary-light text-primary' : '' }}">
                    {{ __('messages.home') }}
                </a>
                <a href="{{ route('products.index') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-gray-900 hover:bg-gray-50 {{ request()->routeIs('products.*') ? 'bg-primary-light text-primary' : '' }}">
                    {{ __('messages.products') }}
                </a>
                    <a href="{{ route('cart.index') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-gray-900 hover:bg-gray-50 {{ request()->routeIs('cart.*') ? 'bg-primary-light text-primary' : '' }}">
                        {{ __('messages.cart') }}
                        @php
                            if (Auth::check()) {
                                $cartCount = \App\Models\Cart::where('user_id', Auth::id())->sum('quantity');
                            } else {
                                $sessionCart = session('cart', []);
                                if (empty($sessionCart)) {
                                    $cartCount = 0;
                                } else {
                                    $first = reset($sessionCart);
                                    if (is_array($first)) {
                                        $cartCount = collect($sessionCart)->sum(function ($item) {
                                            return $item['quantity'] ?? 0;
                                        });
                                    } else {
                                        $cartCount = array_sum($sessionCart);
                                    }
                                }
                            }
                        @endphp
                        <span class="ml-2 inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-white bg-red-600 rounded-full cart-count-badge" data-cart-count="{{ $cartCount }}" style="{{ $cartCount > 0 ? '' : 'display: none;' }}">
                            {{ $cartCount > 99 ? '99+' : $cartCount }}
                        </span>
                    </a>
                @auth
                    @if(auth()->user()->isAdmin())
                        <a href="{{ route('admin.sliders.index') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-gray-900 hover:bg-gray-50 {{ request()->routeIs('admin.*') ? 'bg-primary-light text-primary' : '' }}">
                            {{ __('messages.admin_dashboard') }}
                        </a>
                    @else
                        <a href="{{ route('orders.index') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-gray-900 hover:bg-gray-50 {{ request()->routeIs('orders.index') || request()->routeIs('orders.show') ? 'bg-primary-light text-primary' : '' }}">
                            {{ __('messages.orders') }}
                        </a>
                    @endif
                @else
                    <a href="{{ route('login') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-gray-900 hover:bg-gray-50">
                        {{ __('messages.login') }}
                    </a>
                    <a href="{{ route('register') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-gray-900 hover:bg-gray-50">
                        {{ __('messages.register') }}
                    </a>
                @endauth
                <a href="{{ route('orders.track') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-gray-900 hover:bg-gray-50 {{ request()->routeIs('orders.track') ? 'bg-primary-light text-primary' : '' }}">
                    {{ __('messages.track_order') }}
                </a>
                <div class="border-t border-gray-200 pt-4">
                    @auth
                    <div class="px-3 py-2">
                        <div class="text-sm text-gray-700">
                            {{ __('messages.your_points') }}: <strong class="text-success">{{ Auth::user()->points }}</strong>
                        </div>
                    </div>
                    <div class="px-3 py-2">
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <button type="submit" class="block w-full text-left px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-gray-900 hover:bg-gray-50">
                                {{ __('messages.logout') }}
                            </button>
                        </form>
                    </div>
                    @endauth
                </div>
            </div>
        </div>
    </nav>

    <!-- Notification Popup -->
    <div id="notification-popup" class="fixed top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 z-50 opacity-0 scale-95 transition-all duration-200 ease-in-out" style="display: none;">
        <div class="bg-white shadow-2xl min-w-[280px] max-w-sm border-2" id="notification-content" style="border-radius: 0;">
            <div class="p-5 flex items-center">
                <div class="flex-shrink-0" id="notification-icon">
                    <!-- Icon will be inserted here -->
                </div>
                <div class="ml-3 rtl:mr-3 rtl:ml-0 flex-1">
                    <p class="text-base font-semibold" id="notification-message"></p>
                </div>
                <button type="button" onclick="closeNotification()" class="ml-3 rtl:mr-3 rtl:ml-0 flex-shrink-0 text-gray-400 hover:text-gray-600 transition">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Confirmation Modal -->
    <div id="confirm-modal" class="fixed inset-0 z-50 overflow-y-auto hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
            <!-- Background overlay -->
            <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" id="confirm-modal-backdrop"></div>

            <!-- Modal panel -->
            <div class="inline-block align-bottom bg-white rounded-2xl text-right overflow-hidden shadow-2xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full border-2 border-red-100" id="confirm-modal-panel">
                <div class="bg-gradient-to-br from-white to-red-50 px-8 pt-8 pb-6">
                    <div class="flex items-center justify-center mb-6">
                        <div class="mx-auto flex-shrink-0 flex items-center justify-center h-20 w-20 rounded-full bg-gradient-to-br from-red-100 to-red-200 shadow-lg animate-bounce">
                            <svg class="h-12 w-12 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                            </svg>
                        </div>
                    </div>
                    <div class="text-center">
                        <h3 class="text-3xl font-bold text-gray-900 mb-3" id="confirm-modal-title">⚠️ تأكيد الحذف</h3>
                        <p class="text-lg text-gray-700 mb-2 leading-relaxed" id="confirm-modal-message">هل أنت متأكد من الحذف؟</p>
                        <p class="text-sm text-red-600 font-semibold">لا يمكن التراجع عن هذا الإجراء!</p>
                    </div>
                </div>
                <div class="bg-white px-8 py-6 flex flex-col-reverse sm:flex-row gap-4 sm:justify-end border-t border-gray-200">
                    <button type="button" id="confirm-modal-cancel" class="w-full sm:w-auto inline-flex justify-center items-center px-8 py-3 border-2 border-gray-300 shadow-md text-base font-semibold rounded-xl text-gray-700 bg-white hover:bg-gray-50 hover:border-gray-400 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-400 transition-all transform hover:scale-105">
                        <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                        إلغاء
                    </button>
                    <button type="button" id="confirm-modal-confirm" class="w-full sm:w-auto inline-flex justify-center items-center px-8 py-3 border-2 border-transparent text-base font-semibold rounded-xl text-white bg-gradient-to-r from-red-500 via-red-600 to-red-700 hover:from-red-600 hover:via-red-700 hover:to-red-800 shadow-lg hover:shadow-xl focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 transition-all transform hover:scale-105">
                        <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                        </svg>
                        نعم، احذف الآن
                    </button>
                </div>
            </div>
        </div>
    </div>


    <main class="py-4 pb-20 md:pb-4">
        @yield('content')
    </main>

    <!-- Desktop Footer -->
    <footer class="hidden md:block bg-white border-t mt-12">
        <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8 text-center text-gray-500">
            <p>&copy; {{ date('Y') }} {{ config('app.name') }}. {{ __('messages.all_rights_reserved') }}.</p>
        </div>
    </footer>

    <!-- Mobile Bottom Navigation Footer (Phone App Style) -->
    <nav class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 shadow-2xl md:hidden z-50 safe-area-inset-bottom">
        <div class="flex justify-around items-center h-16 px-2">
            <!-- Home -->
            <a href="{{ route('home') }}" class="flex flex-col items-center justify-center flex-1 h-full transition-colors duration-200 {{ request()->routeIs('home') ? 'text-primary' : 'text-gray-500' }}">
                <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                </svg>
                <span class="text-xs font-medium">{{ __('messages.home') }}</span>
            </a>

            <!-- Products -->
            <a href="{{ route('products.index') }}" class="flex flex-col items-center justify-center flex-1 h-full transition-colors duration-200 {{ request()->routeIs('products.*') ? 'text-primary' : 'text-gray-500' }}">
                <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                </svg>
                <span class="text-xs font-medium">{{ __('messages.products') }}</span>
            </a>

            <!-- Cart -->
            <a href="{{ route('cart.index') }}" class="flex flex-col items-center justify-center flex-1 h-full relative transition-colors duration-200 {{ request()->routeIs('cart.*') ? 'text-primary' : 'text-gray-500' }}">
                <div class="relative">
                    <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                    @php
                        if (Auth::check()) {
                            $cartCount = \App\Models\Cart::where('user_id', Auth::id())->sum('quantity');
                        } else {
                            $sessionCart = session('cart', []);
                            if (empty($sessionCart)) {
                                $cartCount = 0;
                            } else {
                                $first = reset($sessionCart);
                                if (is_array($first)) {
                                    $cartCount = collect($sessionCart)->sum(function ($item) {
                                        return $item['quantity'] ?? 0;
                                    });
                                } else {
                                    $cartCount = array_sum($sessionCart);
                                }
                            }
                        }
                    @endphp
                    <span class="absolute -top-1 -right-2 bg-red-600 text-white text-xs font-bold rounded-full w-5 h-5 flex items-center justify-center text-[10px] cart-count-badge" data-cart-count="{{ $cartCount }}" style="{{ $cartCount > 0 ? '' : 'display: none;' }}">
                        {{ $cartCount > 99 ? '99+' : $cartCount }}
                    </span>
                </div>
                <span class="text-xs font-medium">{{ __('messages.cart') }}</span>
            </a>

            <!-- Orders/Dashboard or Login -->
            @auth
                @if(auth()->user()->isAdmin())
                <a href="{{ route('admin.sliders.index') }}" class="flex flex-col items-center justify-center flex-1 h-full transition-colors duration-200 {{ request()->routeIs('admin.*') ? 'text-primary' : 'text-gray-500' }}">
                    <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                    <span class="text-xs font-medium">{{ __('messages.admin_dashboard') }}</span>
                </a>
                @else
                <a href="{{ route('orders.index') }}" class="flex flex-col items-center justify-center flex-1 h-full transition-colors duration-200 {{ request()->routeIs('orders.index') || request()->routeIs('orders.show') ? 'text-primary' : 'text-gray-500' }}">
                    <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <span class="text-xs font-medium">{{ __('messages.orders') }}</span>
                </a>
                @endif
            @else
            <!-- Login (if not authenticated) -->
            <a href="{{ route('login') }}" class="flex flex-col items-center justify-center flex-1 h-full transition-colors duration-200 {{ request()->routeIs('login') ? 'text-primary' : 'text-gray-500' }}">
                <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                </svg>
                <span class="text-xs font-medium">{{ __('messages.login') }}</span>
            </a>
            @endauth

            <!-- Track Order -->
            <a href="{{ route('orders.track') }}" class="flex flex-col items-center justify-center flex-1 h-full transition-colors duration-200 {{ request()->routeIs('orders.track') ? 'text-primary' : 'text-gray-500' }}">
                <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <span class="text-xs font-medium">{{ __('messages.track_order') }}</span>
            </a>
        </div>
    </nav>

    <script>
        // Mobile menu toggle
        document.getElementById('mobile-menu-button').addEventListener('click', function() {
            const menu = document.getElementById('mobile-menu');
            const icon = document.getElementById('mobile-menu-icon');
            const closeIcon = document.getElementById('mobile-menu-close');
            
            menu.classList.toggle('open');
            
            if (menu.classList.contains('open')) {
                icon.classList.add('hidden');
                closeIcon.classList.remove('hidden');
            } else {
                icon.classList.remove('hidden');
                closeIcon.classList.add('hidden');
            }
        });

        // Close mobile menu when clicking on a link
        document.querySelectorAll('#mobile-menu a').forEach(link => {
            link.addEventListener('click', function() {
                const menu = document.getElementById('mobile-menu');
                const icon = document.getElementById('mobile-menu-icon');
                const closeIcon = document.getElementById('mobile-menu-close');
                
                menu.classList.remove('open');
                icon.classList.remove('hidden');
                closeIcon.classList.add('hidden');
            });
        });

        // Notification Popup System
        function showNotification(message, type = 'success') {
            const popup = document.getElementById('notification-popup');
            const content = document.getElementById('notification-content');
            const messageEl = document.getElementById('notification-message');
            const iconEl = document.getElementById('notification-icon');
            
            messageEl.textContent = message;
            
            // Set colors and icon based on type
            const isRTL = document.dir === 'rtl' || document.documentElement.dir === 'rtl';
            const borderClass = isRTL ? 'border-r-4' : 'border-l-4';
            
            if (type === 'success') {
                content.className = `bg-white shadow-2xl ${borderClass} border-success min-w-[280px] max-w-sm border-2`;
                content.style.borderRadius = '0';
                iconEl.innerHTML = `
                    <svg class="h-7 w-7 text-success" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                `;
                messageEl.className = 'text-base font-semibold text-success';
            } else if (type === 'error') {
                content.className = `bg-white shadow-2xl ${borderClass} border-primary min-w-[280px] max-w-sm border-2`;
                content.style.borderRadius = '0';
                iconEl.innerHTML = `
                    <svg class="h-7 w-7 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                `;
                messageEl.className = 'text-base font-semibold text-primary';
            } else if (type === 'info') {
                content.className = `bg-white shadow-2xl ${borderClass} border-secondary min-w-[280px] max-w-sm border-2`;
                content.style.borderRadius = '0';
                iconEl.innerHTML = `
                    <svg class="h-7 w-7 text-secondary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                `;
                messageEl.className = 'text-base font-semibold text-secondary';
            } else if (type === 'loading') {
                content.className = `bg-white shadow-2xl ${borderClass} border-secondary min-w-[280px] max-w-sm border-2`;
                content.style.borderRadius = '0';
                iconEl.innerHTML = `
                    <svg class="h-7 w-7 text-secondary animate-spin" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                `;
                messageEl.className = 'text-base font-semibold text-secondary';
            }
            
            // Show popup
            popup.style.display = 'block';
            setTimeout(() => {
                popup.classList.remove('opacity-0', 'scale-95');
                popup.classList.add('opacity-100', 'scale-100');
            }, 10);
            
            // Auto hide after 5 seconds (except for loading type)
            if (type !== 'loading') {
                setTimeout(() => {
                    closeNotification();
                }, 5000);
            }
        }

        function closeNotification() {
            const popup = document.getElementById('notification-popup');
            popup.classList.remove('opacity-100', 'scale-100');
            popup.classList.add('opacity-0', 'scale-95');
            setTimeout(() => {
                popup.style.display = 'none';
            }, 300);
        }

        // Show notifications from session
        @if(session('success'))
            showNotification({!! json_encode(session('success')) !!}, 'success');
        @endif

        @if(session('error'))
            showNotification({!! json_encode(session('error')) !!}, 'error');
        @endif

        @if(session('info'))
            showNotification({!! json_encode(session('info')) !!}, 'info');
        @endif

        // Handle add to cart forms
        document.querySelectorAll('form[action*="cart.store"]').forEach(form => {
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                const button = form.querySelector('button[type="submit"]');
                const originalText = button ? button.textContent.trim() : '';
                
                // Show loading notification
                showNotification('جاري الإضافة في السلة...', 'loading');
                
                // Disable button and show loading state
                if (button) {
                    button.disabled = true;
                    button.style.opacity = '0.6';
                    button.textContent = 'جاري الإضافة...';
                }
                
                // Submit form via fetch for better UX
                const formData = new FormData(form);
                const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
                
                fetch(form.action, {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'X-CSRF-TOKEN': csrfToken || '',
                    }
                })
                .then(response => {
                    // Check if response is ok
                    if (!response.ok) {
                        return response.json().then(err => {
                            throw new Error(err.message || 'حدث خطأ');
                        }).catch(() => {
                            throw new Error('حدث خطأ في الاتصال');
                        });
                    }
                    return response.json();
                })
                .then(data => {
                    // Close loading notification
                    closeNotification();
                    
                    // Show success notification
                    setTimeout(() => {
                        showNotification(data.message || 'تم الإضافة', 'success');
                    }, 100);
                    
                    // Update cart count in header and mobile nav if provided
                    if (typeof data.cart_count !== 'undefined') {
                        const count = parseInt(data.cart_count, 10) || 0;
                        console.log('Updating cart count to:', count);
                        const badges = document.querySelectorAll('.cart-count-badge');
                        console.log('Found badges:', badges.length);
                        badges.forEach(el => {
                            el.textContent = count > 99 ? '99+' : count;
                            el.setAttribute('data-cart-count', count);
                            // إظهار/إخفاء الـ badge حسب العدد
                            if (count > 0) {
                                el.style.display = el.classList.contains('inline-flex') ? 'inline-flex' : 'flex';
                            } else {
                                el.style.display = 'none';
                            }
                        });
                    } else {
                        console.log('cart_count not found in response:', data);
                    }

                    // Re-enable button and restore text
                    if (button) {
                        button.disabled = false;
                        button.style.opacity = '1';
                        button.textContent = originalText;
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    // Close loading notification
                    closeNotification();
                    
                    // Show error notification
                    setTimeout(() => {
                        showNotification(error.message || 'حدث خطأ أثناء الإضافة', 'error');
                    }, 100);
                    
                    // Re-enable button
                    if (button) {
                        button.disabled = false;
                        button.style.opacity = '1';
                        button.textContent = originalText;
                    }
                });
            });
        });

        // Confirmation Modal System
        let confirmCallback = null;
        let confirmForm = null;

        function playAlertSound() {
            try {
                const audioContext = new (window.AudioContext || window.webkitAudioContext)();
                
                // Create a more noticeable alert sound
                const oscillator1 = audioContext.createOscillator();
                const oscillator2 = audioContext.createOscillator();
                const gainNode = audioContext.createGain();
                
                oscillator1.connect(gainNode);
                oscillator2.connect(gainNode);
                gainNode.connect(audioContext.destination);
                
                // Two-tone alert sound
                oscillator1.frequency.value = 800;
                oscillator1.type = 'sine';
                oscillator2.frequency.value = 600;
                oscillator2.type = 'sine';
                
                gainNode.gain.setValueAtTime(0.4, audioContext.currentTime);
                gainNode.gain.exponentialRampToValueAtTime(0.01, audioContext.currentTime + 0.4);
                
                oscillator1.start(audioContext.currentTime);
                oscillator1.stop(audioContext.currentTime + 0.4);
                oscillator2.start(audioContext.currentTime);
                oscillator2.stop(audioContext.currentTime + 0.4);
            } catch (e) {
                console.log('Audio play failed:', e);
            }
        }

        function showConfirmModal(message, title = 'تأكيد الحذف', callback = null, form = null) {
            // Play alert sound
            playAlertSound();

            const modal = document.getElementById('confirm-modal');
            const backdrop = document.getElementById('confirm-modal-backdrop');
            const panel = document.getElementById('confirm-modal-panel');
            const titleEl = document.getElementById('confirm-modal-title');
            const messageEl = document.getElementById('confirm-modal-message');

            // Safety check: ensure all elements exist
            if (!modal || !backdrop || !panel || !titleEl || !messageEl) {
                console.error('Confirm modal elements not found');
                // Fallback to browser confirm
                if (confirm(message || 'هل أنت متأكد من الحذف؟ لا يمكن التراجع عن هذا الإجراء.')) {
                    if (form) {
                        form.submit();
                    } else if (callback) {
                        callback();
                    }
                }
                return;
            }

            titleEl.textContent = title;
            messageEl.textContent = message || 'هل أنت متأكد من الحذف؟ لا يمكن التراجع عن هذا الإجراء.';
            
            confirmCallback = callback;
            confirmForm = form;

            modal.classList.remove('hidden');
            backdrop.classList.add('opacity-0');
            panel.classList.add('opacity-0', 'translate-y-4', 'sm:scale-95');

            setTimeout(() => {
                backdrop.classList.remove('opacity-0');
                backdrop.classList.add('opacity-100');
                panel.classList.remove('opacity-0', 'translate-y-4', 'sm:scale-95');
                panel.classList.add('opacity-100', 'translate-y-0', 'sm:scale-100');
            }, 10);
        }

        function closeConfirmModal() {
            const modal = document.getElementById('confirm-modal');
            const backdrop = document.getElementById('confirm-modal-backdrop');
            const panel = document.getElementById('confirm-modal-panel');

            if (!modal || !backdrop || !panel) return;

            backdrop.classList.remove('opacity-100');
            backdrop.classList.add('opacity-0');
            panel.classList.remove('opacity-100', 'translate-y-0', 'sm:scale-100');
            panel.classList.add('opacity-0', 'translate-y-4', 'sm:scale-95');

            setTimeout(() => {
                modal.classList.add('hidden');
                confirmCallback = null;
                confirmForm = null;
            }, 200);
        }

        // Initialize modal event listeners when DOM is ready
        function initConfirmModal() {
            const confirmBtn = document.getElementById('confirm-modal-confirm');
            const cancelBtn = document.getElementById('confirm-modal-cancel');
            const backdrop = document.getElementById('confirm-modal-backdrop');

            if (!confirmBtn || !cancelBtn || !backdrop) {
                // Retry if elements don't exist yet
                setTimeout(initConfirmModal, 100);
                return;
            }

            // Confirm button handler
            confirmBtn.addEventListener('click', function() {
                if (confirmForm) {
                    confirmForm.submit();
                } else if (confirmCallback) {
                    confirmCallback();
                }
                closeConfirmModal();
            });

            // Cancel button handler
            cancelBtn.addEventListener('click', closeConfirmModal);

            // Close on backdrop click
            backdrop.addEventListener('click', closeConfirmModal);
        }

        // Close on Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                const modal = document.getElementById('confirm-modal');
                if (modal && !modal.classList.contains('hidden')) {
                    closeConfirmModal();
                }
            }
        });

        // Replace all confirm() with custom modal
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize modal buttons
            initConfirmModal();
            // Find all delete forms
            document.querySelectorAll('form.delete-form').forEach(form => {
                form.addEventListener('submit', function(e) {
                    e.preventDefault();
                    const message = this.getAttribute('data-confirm-message') || 'هل أنت متأكد من الحذف؟ لا يمكن التراجع عن هذا الإجراء.';
                    showConfirmModal(message, 'تأكيد الحذف', null, this);
                });
            });

            // Find all forms with onsubmit confirm (fallback)
            document.querySelectorAll('form[onsubmit*="confirm"]').forEach(form => {
                form.onsubmit = function(e) {
                    e.preventDefault();
                    const message = form.getAttribute('data-confirm-message') || 'هل أنت متأكد من الحذف؟ لا يمكن التراجع عن هذا الإجراء.';
                    showConfirmModal(message, 'تأكيد الحذف', null, form);
                    return false;
                };
            });

            // Find all buttons with data-confirm attribute
            document.querySelectorAll('[data-confirm]').forEach(button => {
                button.addEventListener('click', function(e) {
                    if (this.tagName === 'BUTTON' && this.type === 'submit') {
                        e.preventDefault();
                        const form = this.closest('form');
                        const message = this.getAttribute('data-confirm') || 'هل أنت متأكد من الحذف؟ لا يمكن التراجع عن هذا الإجراء.';
                        showConfirmModal(message, 'تأكيد الحذف', null, form);
                    }
                });
            });
        });

        // Fallback: Initialize immediately if DOM is already loaded
        if (document.readyState === 'loading') {
            // DOM is still loading, wait for DOMContentLoaded
        } else {
            // DOM is already loaded, initialize immediately
            initConfirmModal();
        }

    </script>
    @stack('scripts')
</body>
</html>

