@extends('layouts.app')

@section('title', __('messages.checkout'))

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="py-8">
        <h1 class="text-3xl font-bold mb-6">{{ __('messages.checkout') }}</h1>
        
        <div class="grid md:grid-cols-2 gap-8">
            <div>
                <h2 class="text-2xl font-semibold mb-4">{{ __('messages.enter_shipping_details') }}</h2>
                <form action="{{ route('orders.store') }}" method="POST" class="bg-white p-6 rounded-lg shadow">
                    @csrf
                    <div class="mb-4">
                        <label class="block text-gray-700 mb-2">{{ __('messages.shipping_name') }}</label>
                        <input type="text" name="shipping_name" value="{{ old('shipping_name', Auth::user()->name) }}" required
                               class="w-full px-4 py-2 border rounded-lg">
                        @error('shipping_name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                    
                    <div class="mb-4">
                        <label class="block text-gray-700 mb-2">{{ __('messages.shipping_phone') }}</label>
                        <input type="text" name="shipping_phone" value="{{ old('shipping_phone') }}" required
                               class="w-full px-4 py-2 border rounded-lg">
                        @error('shipping_phone')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                    
                    <div class="mb-4">
                        <label class="block text-gray-700 mb-2">{{ __('messages.shipping_address') }}</label>
                        <textarea name="shipping_address" required class="w-full px-4 py-2 border rounded-lg">{{ old('shipping_address') }}</textarea>
                        @error('shipping_address')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                    
                    <div class="mb-4">
                        <label class="block text-gray-700 mb-2">{{ __('messages.shipping_city') }}</label>
                        <input type="text" name="shipping_city" value="{{ old('shipping_city') }}" required
                               class="w-full px-4 py-2 border rounded-lg">
                        @error('shipping_city')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                    
                    <div class="mb-4">
                        <label class="block text-gray-700 mb-2">{{ __('messages.notes') }}</label>
                        <textarea name="notes" class="w-full px-4 py-2 border rounded-lg">{{ old('notes') }}</textarea>
                    </div>
                    
                    <button type="submit" class="w-full bg-primary text-white px-6 py-3 rounded-lg hover:opacity-90 transition">
                        {{ __('messages.place_order') }}
                    </button>
                </form>
            </div>
            
            <div>
                <h2 class="text-2xl font-semibold mb-4">{{ __('messages.order_summary') ?? 'Order Summary' }}</h2>
                <div class="bg-white p-6 rounded-lg shadow">
                    @foreach($cartItems as $item)
                    <div class="flex justify-between mb-4 pb-4 border-b">
                        <div>
                            <p class="font-medium">{{ $item->product->name }}</p>
                            <p class="text-sm text-gray-500">{{ __('messages.quantity') }}: {{ $item->quantity }}</p>
                        </div>
                        <p class="font-medium">{{ number_format($item->quantity * $item->product->price, 2) }} ر.ع</p>
                    </div>
                    @endforeach
                    
                    <div class="mt-4 pt-4 border-t">
                        <div class="flex justify-between text-xl font-bold">
                            <span>{{ __('messages.total') }}</span>
                            <span>{{ number_format($total, 2) }} ر.ع</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection





