@extends('layouts.app')

@section('title', __('messages.track_order'))

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="py-8">
        <h1 class="text-3xl font-bold mb-6">{{ __('messages.track_order') }}</h1>
        
        <div class="bg-white rounded-lg shadow p-6 mb-6">
            <form method="GET" action="{{ route('orders.track') }}" class="flex gap-4">
                <input type="text" name="order_number" value="{{ request('order_number') }}" 
                       placeholder="{{ __('messages.enter_order_number') }}" 
                       class="flex-1 px-4 py-2 border rounded-lg" required>
                <button type="submit" class="bg-primary text-white px-6 py-2 rounded-lg hover:opacity-90 transition">
                    {{ __('messages.track') }}
                </button>
            </form>
        </div>

        @if($order)
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-2xl font-semibold mb-4">{{ __('messages.tracking_info') }}</h2>
            
            <div class="mb-6">
                <h3 class="font-semibold mb-2">{{ __('messages.order_number') }}</h3>
                <p class="text-gray-600">{{ $order->order_number }}</p>
            </div>
            
            <div class="mb-6">
                <h3 class="font-semibold mb-2">{{ __('messages.order_status') }}</h3>
                <span class="px-3 py-1 rounded-full text-sm font-medium
                    @if($order->status === 'pending') bg-yellow-100 text-yellow-800
                    @elseif($order->status === 'processing') bg-primary-light/30 text-primary
                    @elseif($order->status === 'shipped') bg-secondary/30 text-secondary
                    @elseif($order->status === 'delivered') bg-success/30 text-success
                    @else bg-primary/20 text-primary
                    @endif">
                    {{ __('messages.' . $order->status) }}
                </span>
            </div>

            <div class="space-y-2 mb-6">
                <div class="flex items-center">
                    <div class="w-4 h-4 rounded-full {{ $order->status !== 'cancelled' ? 'bg-success' : 'bg-gray-300' }} mr-3 rtl:ml-3 rtl:mr-0"></div>
                    <div>
                        <p class="font-medium">{{ __('messages.pending') }}</p>
                        <p class="text-sm text-gray-500">{{ $order->created_at->format('Y-m-d H:i') }}</p>
                    </div>
                </div>
                
                @if($order->status !== 'pending' && $order->status !== 'cancelled')
                <div class="flex items-center">
                    <div class="w-4 h-4 rounded-full {{ in_array($order->status, ['processing', 'shipped', 'delivered']) ? 'bg-success' : 'bg-gray-300' }} mr-3 rtl:ml-3 rtl:mr-0"></div>
                    <div>
                        <p class="font-medium">{{ __('messages.processing') }}</p>
                    </div>
                </div>
                @endif
                
                @if(in_array($order->status, ['shipped', 'delivered']))
                <div class="flex items-center">
                    <div class="w-4 h-4 rounded-full bg-success mr-3 rtl:ml-3 rtl:mr-0"></div>
                    <div>
                        <p class="font-medium">{{ __('messages.shipped') }}</p>
                        @if($order->shipped_at)
                        <p class="text-sm text-gray-500">{{ $order->shipped_at->format('Y-m-d H:i') }}</p>
                        @endif
                    </div>
                </div>
                @endif
                
                @if($order->status === 'delivered')
                <div class="flex items-center">
                    <div class="w-4 h-4 rounded-full bg-success mr-3 rtl:ml-3 rtl:mr-0"></div>
                    <div>
                        <p class="font-medium">{{ __('messages.delivered') }}</p>
                        @if($order->delivered_at)
                        <p class="text-sm text-gray-500">{{ $order->delivered_at->format('Y-m-d H:i') }}</p>
                        @endif
                    </div>
                </div>
                @endif
            </div>

            <div class="mt-6">
                <a href="{{ route('orders.show', $order->id) }}" class="text-primary hover:opacity-80">
                    {{ __('messages.view_full_details') ?? 'View Full Details' }}
                </a>
            </div>
        </div>
        @elseif(request('order_number'))
        <div class="bg-white rounded-lg shadow p-6 text-center">
            <p class="text-red-500">{{ __('messages.order_not_found') }}</p>
        </div>
        @endif
    </div>
</div>
@endsection





